import OOPLS.CompleteGraphPanel;
import OOPLS.DroppedBallPanel;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.WindowConstants;

public class DualClient extends JFrame {
    DroppedBallPanel dbp = new DroppedBallPanel();
    CompleteGraphPanel cgp = new CompleteGraphPanel(17);
    JButton ballDropButton = new JButton("Drop ball");
    JButton randomizeButton = new JButton(
        "Randomize vertices");
    JPanel buttonPanel = new JPanel();
    public DualClient() {
        initComponents();
    }
    public void initComponents() {
        setDefaultCloseOperation(
            WindowConstants.EXIT_ON_CLOSE);
        setBounds(10,10,500,600);
        Container cp = getContentPane();
        cp.setLayout(new BoxLayout(cp,BoxLayout.Y_AXIS));
        cp.add(dbp);
        dbp.start();
        buttonPanel.setLayout(
            new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        buttonPanel.add(ballDropButton);
        ballDropButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    dbp.drop();
                }
            });
        randomizeButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    int numVertices = 
                        new Random().nextInt() % 48 + 3;
                    cgp.setNumVertices(numVertices);
                    cgp.repaint();
                } 
            });
        buttonPanel.add(randomizeButton);
        cp.add(buttonPanel);
        cp.add(cgp);
    }
    public static void main(String args[]) {
        EventQueue.invokeLater(new Runnable(){
            public void run() {
               new 
                DualClient().setVisible(true);
            }
        });
    }
}
